/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.net.covers1624.quack.io;

import java.io.OutputStream;
import java.util.function.Consumer;

public class ConsumingOutputStream
extends OutputStream {
    private final Consumer<String> consumer;
    private final StringBuilder buffer = new StringBuilder();

    public ConsumingOutputStream(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void write(int b) {
        char ch = (char)(b & 0xFF);
        this.buffer.append(ch);
        if (ch == '\n') {
            this.flush();
        }
    }

    @Override
    public void flush() {
        if (this.buffer.length() == 0) {
            return;
        }
        char end = this.buffer.charAt(this.buffer.length() - 1);
        if (end == '\n') {
            this.consumer.accept(this.buffer.toString().trim());
            this.buffer.setLength(0);
        }
    }
}

